


dofile("Scripts/Database/Weapons/warheads.lua")

local GALLON_TO_KG = 3.785 * 0.8
local INCHES_TO_M = 0.0254
local POUNDS_TO_KG = 0.453592

local tracer_on_time = 0.01   
local barrel_smoke_level = 1.0
local barrel_smoke_opacity = 0.1   






--HE
    declare_weapon({category = CAT_SHELLS, name = "20_M56_HEI", user_name = _("20x102_M56_HEI"),
        model_name      = "tracer_bullet_red",   
        projectile      = "Ball",
        mass            = 0.1, -- Bullet mass
        round_mass      = 0.263 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.163 + 0.020, -- Empty shell (+ link if links are stored as well)
        explosive       = 1.70,
		payload         = 1.70,
        payloadEffect   = "Fragmentation",
        payloadMaterial = "TNT",
        v0              = 1050.0,
        Dv0             = 0.0060,
        Da0             = 0.0022,
        Da1             = 0.0,
        life_time       = 30,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 204,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

--HE-T
    declare_weapon({category = CAT_SHELLS, name = "20_M242_HEI-T", user_name = _("20x102_M242_HEI-T"),
        model_name      = "tracer_bullet_red",
        projectile      = "Ball",
        mass            = 0.1, -- Bullet mass
        round_mass      = 0.263 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.163 + 0.020, -- Empty shell (+ link if links are stored as well)
		explosive    	= 1.70, 
		payload         = 1.70,
        payloadEffect   = "Fragmentation",
        payloadMaterial = "TNT",		
		v0    			= 1050.0,
		Dv0   			= 0.0060,
		Da0    			= 0.0022,
		Da1     		= 0.0,
        life_time       = 30,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = 1,
        smoke_tail_life_time = 0,
        cartridge       = 204,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

--API
    declare_weapon({category = CAT_SHELLS, name = "20_M53_API", user_name = _("20x102_M53_API"),
        model_name      = "tracer_bullet_red",
        projectile      = "AP",
        mass            = 0.1, -- Bullet mass
        round_mass      = 0.263 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.163 + 0.020, -- Empty shell (+ link if links are stored as well)
        explosive       = 0.0,
        payload         = 1.7,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
		v0             	= 1050.0,
		Dv0            	= 0.0060,
		Da0            	= 0.0022,
		Da1            	= 0.0,
        life_time       = 30,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 204,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

--API Tracer
    declare_weapon({category = CAT_SHELLS, name = "20_M220_Tracer", user_name = _("20x102_M220_Tracer"),
        model_name      = "tracer_bullet_red",
        projectile      = "AP",
        mass            = 0.1, -- Bullet mass
        round_mass      = 0.263 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.163 + 0.020, -- Empty shell (+ link if links are stored as well)
		explosive       = 0.0,
        payload         = 1.7,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
		v0             	= 1050.0,
		Dv0            	= 0.0060,
		Da0            	= 0.0022,
		Da1            	= 0.0,
        life_time       = 30,
        caliber         = 20,
        s               = 0.0,
        j               = 0.0,
        l               = 0.0,
        charTime        = 0,
        cx              = {0.5,1.27,0.70,0.200,2.30},
        k1              = 2.0e-08,
        tracer_off      = 1,
        smoke_tail_life_time = 0,
        cartridge       = 204,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,
    })

--SAPHEI
    declare_weapon({category = CAT_SHELLS, name = "20_M70LD_SAPHEI", user_name = _("20x102_M70LD_SAPHEI"),
        model_name      = "tracer_bullet_red",
        projectile      = "AP",
        mass            = 0.1, -- Bullet mass
        round_mass      = 0.263 + 0.020, -- Assembled shell + link
        cartridge_mass  = 0.163 + 0.020, -- Empty shell (+ link if links are stored as well)
		explosive      	= 1.7,       
		payload         = 1.7,
        payloadEffect   = "Thermal",
        payloadMaterial = "Thermite",
		v0             	= 1040.0,
		Dv0            	= 0.0060,
		Da0            	= 0.0015,
		Da1            	= 0.0,
        life_time       = 30,
        caliber         = 20,
        s               = 0,
        j               = 0,
        l               = 0,
        charTime        = 0,
        cx              = {0.12,0.7,0.80,0.22,1.9},
        k1              = 1.1e-08,
        tracer_off      = -1,
        smoke_tail_life_time = 0,
        cartridge       = 0,
        scale_smoke     = barrel_smoke_level,
        smoke_opacity   = barrel_smoke_opacity,  
    })




function OH6_GIAT_M621(tbl) 

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "OH6_GIAT_M621"
	tbl.supply 	 = 
	{
		shells	= {
					"20_M56_HEI",
					"20_M242_HEI-T", 
					"20_M53_API",
					"20_M220_Tracer",
					"20_M70LD_SAPHEI",
				 },
		mixes	= {
					{1},
					{2},
					{3},
					{4},
					{5},
				}, 
		count	= 240,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes  
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 1,
		rates 			 = {740},  
		recoil_coeff 	 = 0.2,   
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates      
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-1.707, -0.322, 0.153} -- position from muzzle connector pos
	tbl.ejector_dir 			= tbl.ejector_dir  
	tbl.supply_position  		= tbl.supply_position or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1200
	tbl.drop_cartridge 			= 204 -- drop shell shape/size from  aircraft_gun_mounts.lua
	tbl.muzzle_pos				= tbl.muzzle_pos or {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 	or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0      
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}, 
					   }
	end
	return declare_weapon(tbl)
end



 declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_GIAT_M261_1}",   
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"oh58brau.png",
	displayName		=	_("GIAT M621 Combat Mix"),-- loadout editor name
	Weight				= 45.5 + (240*0.263), -- INCLUDE AMMO FOR FULL WEIGHT
    Weight_Empty        = 45.5,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "SA342_GIAT_1"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_GIAT_M621({
				ejector_dir = {0,-1,1}, 
				mixes					= {{5,3,2,5,3,2}},       
				muzzle_pos				= {1.64,-0.36,0.685},            
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {-1.661,0.021,-0.045}   
			})			
	},	
	shape_table_data = {{file  	 = 'SA342_GIAT_1';	username = 'GIAT M621 Combat Mix'; index = WSTYPE_PLACEHOLDER;}}
}) 
  
 declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_GIAT_M261_2}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"oh58brau.png",
	displayName		=	_("GIAT M621 Tracer"),-- loadout editor name
	Weight				= 45.5 + (240*0.263), -- INCLUDE AMMO FOR FULL WEIGHT
    Weight_Empty        = 45.5,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "SA342_GIAT_2"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= {
			OH6_GIAT_M621({
				ejector_dir = {0,-1,1},
				mixes					= {{2,4}},         
				muzzle_pos				= {1.64,-0.36,0.685},                        
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {-1.661,0.021,-0.045}  
			})			
	},	
	shape_table_data = {{file  	 = 'SA342_GIAT_2';	username = 'GIAT M621 Tracer'; index = WSTYPE_PLACEHOLDER;}}
})   
  
 declare_loadout({
	category 		=   CAT_PODS, 
	CLSID	 		=  "{OH6_GIAT_M261_3}",  
	attribute		=   {wsType_Weapon,wsType_GContainer,wsType_Cannon_Cont,WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= 	{wsType_Weapon,wsType_Shell,wsType_Shell,WSTYPE_PLACEHOLDER},
	Picture			=	"oh58brau.png",
	displayName		=	_("GIAT M621 HE-T/AP"),-- loadout editor name
	Weight				= 45.5 + (240*0.263), -- INCLUDE AMMO FOR FULL WEIGHT
    Weight_Empty        = 45.5,
	Cx_pil			=	0.001220703125,
	Elements  		= {{ShapeName = "SA342_GIAT_3"}},     
	kind_of_shipping = 2,--SOLID_MUNITION
	gun_mounts		= { 
			OH6_GIAT_M621({
				ejector_dir = {0,-1,1},
				mixes					= {{2,3,2,3}},       
				muzzle_pos				= {1.64,-0.36,0.685},             
				muzzle_pos_connector	= "Point_Gun",   
				supply_position = {-1.661,0.021,-0.045}  
			})			
	},	
	shape_table_data = {{file  	 = 'SA342_GIAT_3';	username = 'GIAT M621 HE-T/AP'; index = WSTYPE_PLACEHOLDER;}}
})   
  
